# load libraries
library(ggplot2)
library(globaltest)

barcodeFiles = c(
"plod2_16.txt",
"plod2_17.txt",
"plod2_18.txt",
"plod2_13.txt",
"plod2_14.txt",
"plod2_15.txt")

# genotype of each animal
groupIDs = t(c("Mutant","Mutant","Mutant","Control","Control","Control"))
standardLengths = c(20.8,20.9,18.9,27.1,28.1,28.5)

paramsToAnalyze = c(3:5,11:13,19:21,26) #params to analyze
vertsToAnalyze = c(1:16)

#calculate mean coordinate
meanCoordVal = mean(standardLengths[1:3])

#read in a and b
a = scan("aMatrix.txt")
b = scan("bMatrix.txt")

for (n in 1:length(groupIDs)) {
	fishDataInit = read.table(barcodeFiles[n],header=T)
	fishData = unlist(fishDataInit[vertsToAnalyze,paramsToAnalyze])
	
	X0 = meanCoordVal
	Xi = standardLengths[n]
	Yi = fishData
	
	# transform Yi
	Yi[49:64] = fishData[49:64]*fishData[1:16]*(1e-9)
	Yi[65:80] = fishData[65:80]*fishData[17:32]*(1e-9)
	Yi[81:96] = fishData[81:96]*fishData[33:48]*(1e-9)
	
	YiStar = array(0,length(fishData))
	for (k in 1:length(fishData)) {
		YiStar[k] = Yi[k]*((X0/Xi)^b[k])
	}
	
	newFishData = YiStar
	newFishData[49:64] = YiStar[49:64]/YiStar[1:16]/(1e-9)
	newFishData[65:80] = YiStar[65:80]/YiStar[17:32]/(1e-9)
	newFishData[81:96] = YiStar[81:96]/YiStar[33:48]/(1e-9)
	
	fileData = read.table(barcodeFiles[n],header=T)
	fileData[vertsToAnalyze,paramsToAnalyze] = newFishData
	write.table(fileData,gsub(".txt","_si_inter.txt",barcodeFiles[n]))

}